<?php
namespace VM\ApiBundle\Entity;

use Doctrine\ORM\Mapping as ORM;
use JMS\Serializer\Annotation\ExclusionPolicy;
use JMS\Serializer\Annotation\Expose;
use JMS\Serializer\Annotation\Groups as AnnotationGroups;
use JMS\Serializer\Annotation\Type;
use JMS\Serializer\Annotation\SerializedName;
use JMS\Serializer\Annotation\Accessor;

/**
 * VM\ApiBundle\Entity\BankService
 *
 * @ORM\Table(name="bank_service")
 * @ORM\Entity(repositoryClass="VM\ApiBundle\Repository\BankServiceRepository")
 *
 * @ExclusionPolicy("all")
 */
class BankService
{
    /**
     * @var integer $id
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     *
     * @Expose
     * @AnnotationGroups({"bankServiceDetails","companyDetails", "companyBankServiceDetails"})
     */
    private $id;

    /**
     * @var string $name
     *
     * @ORM\Column(name="name", type="string", length=255)
     *
     * @Expose
     * @AnnotationGroups({"bankServiceDetails","companyDetails", "companyBankServiceDetails"})
     */
    private $name;

    /**
     * @var string $symbol
     *
     * @ORM\Column(name="symbol", type="string", length=50)
     *
     * @Expose
     * @AnnotationGroups({"bankServiceDetails","companyDetails", "companyBankServiceDetails"})
     */
    private $symbol;

    /**
     * @var integer
     *
     * @ORM\Column(name="step_index", type="integer")
     *
     * @Expose
     * @AnnotationGroups({"bankServiceDetails"})
     */
    private $stepIndex;

    /**
     * @ORM\OneToMany(targetEntity="BankServiceOptions", mappedBy="bankService")
     *
     * @Expose
     * @AnnotationGroups({"bankServiceDetails", "companyBankServiceDetails"})
     */
    protected $types;

    /**
     * Constructor
     */
    public function __construct()
    {
        $this->types = new \Doctrine\Common\Collections\ArrayCollection();
    }
    
    /**
     * Get id
     *
     * @return integer 
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set name
     *
     * @param string $name
     * @return BankService
     */
    public function setName($name)
    {
        $this->name = $name;
    
        return $this;
    }

    /**
     * Get name
     *
     * @return string 
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Set symbol
     *
     * @param string $symbol
     * @return BankService
     */
    public function setSymbol($symbol)
    {
        $this->symbol = $symbol;
    
        return $this;
    }

    /**
     * Get symbol
     *
     * @return string 
     */
    public function getSymbol()
    {
        return $this->symbol;
    }

    /**
     * Set stepIndex
     *
     * @param integer $stepIndex
     * @return BankService
     */
    public function setStepIndex($stepIndex)
    {
        $this->stepIndex = $stepIndex;
    
        return $this;
    }

    /**
     * Get stepIndex
     *
     * @return integer 
     */
    public function getStepIndex()
    {
        return $this->stepIndex;
    }

    /**
     * Add types
     *
     * @param \VM\ApiBundle\Entity\BankServiceOptions $types
     * @return BankService
     */
    public function addType(\VM\ApiBundle\Entity\BankServiceOptions $types)
    {
        $this->types[] = $types;
    
        return $this;
    }

    /**
     * Remove types
     *
     * @param \VM\ApiBundle\Entity\BankServiceOptions $types
     */
    public function removeType(\VM\ApiBundle\Entity\BankServiceOptions $types)
    {
        $this->types->removeElement($types);
    }

    /**
     * Get types
     *
     * @return \Doctrine\Common\Collections\Collection 
     */
    public function getTypes()
    {
        return $this->types;
    }
}